// ****************
// gpm.h file
// *****************
/*
Gpm

License: GNU General Public License

Cordier Yves 
V1.0  : 23/09/2025
v1.1  : 24/09/2025
        including various versions of the shield 
		GPAM, GPMS, GPMP
		

this librarie is suitable to several versions of DPM shield
 a: The first DS-GPM shield 
 b: The extend DS-GPAM shield
 c: The actual DS-GPM+ shield
 
 a : This shield has in addition 4 I/O 
     which could be positioned in digital Output | digital Input | anolog Input (8bits)
 b : This shield has in addition 4 I/O 
     which could be positioned in digital Output | digital Input | anolog Input (8bits)
	 In addition a3 axis accelerometer 
 c : This shield has only a 3 axis accelerometer
 
 However all functions discribe un this librarie gives a value with all versions.
 If they supposed to manage with a non existent feature, it returs 0
 
 You must declear the version you have
 before including the librarie in your sketch
 
 a : #define _GPAM  // correpond at IES-Shield-GPAM
 b : #define _GPM  // correspond at DS-GPM Shield
 c : #define _GPMP // correspond at sHLD-GPM+
 exemple :
 
 //#define _GPAM // uncomment this line for GPMA version correpond at IES-Shield-GPAM
 //#define _GPM  // uncomment this line for GPM version correspond at DS-GPM Shield
 //#define _GPMP // uncomment this line for GPMP version correspond at sHLD-GPM+
 
 #include <gpm.h>
 
 note that if no version is specified, the basics functions of gps 
 will be operationals
 
	
*/

#ifndef __GMP_H__
#define __GMP_H__

#if defined(ARDUINO) && ARDUINO >= 100
#include "Arduino.h"
#else
#include "WProgram.h"
#endif

#include <Wire.h>

#define ANALOG (10)  // utilisé pour definir les entrées analogiques du module

// Les adresses des registres en fonction des versions de circuits


#ifdef _GPAM
#pragma message("GPAM version")
#define _Ax 57
#define _Ay 59
#define _Az 61
#define _PITCH 63
#define _ROLL 64
#define _ANA0 65
#define _ANA1 66
#define _ANA2 67
#define _ANA3 68
#define _IO   69
#undef _GPMP
#undef _GPM
#define _CHOICE
#endif

#ifdef _GPM
#pragma message("GPM version")
#define _ANA0 57
#define _ANA1 58
#define _ANA2 59
#define _ANA3 60
#define _IO   61
#undef _GPAM
#undef _GPMP
#define _CHOICE
#endif

#ifdef _GPMP
#pragma message("GPMP version")
#define _Ax 57
#define _Ay 59
#define _Az 61
#define _PITCH 63
#define _ROLL 64
#undef  _GPAM
#undef  _GPM
#define _CHOICE
#endif

#ifndef _CHOICE
#pragma message("no specific shield defined")
#endif
class Gpm {
	// Les variables internes
private:
	byte GPM = 0x68;  // l'adresse i2c de base
	#ifdef _IO
	// gestion des entrées sorties du module numérotées de 1 à 4
	// copie des registres internes au module accessibles en ecriture seul
	byte masqueInputDirection = 0x00;  //R0
	byte masqueIoType = 0x00;          //R1
	#endif
	#ifdef _AX
	// Les valeurs de référence des accéléromètres dans les trois directions
	int v1Gx=1;
	#endif 
	#ifdef _AY
	int v1Gy=1;
	#endif
	#ifdef _AZ
	int v1Gz=1;
	#endif

public:
	// Les constructeurs
	// avec l'adresse par defaut 0x68
	gpm();
	// avec l'adresse a
	gpm(byte a);
	// manipulation de l'adresse
	void setAdress(byte a);
	// initialisation de la communication
	void init();

	// definition des modes d'entrée / Sortie similaire à pinMode Arduino
	// Ici le mode INPUT ey INPUT_PULLUP sont traités de manière identique
	// Il appartient à l'utilisateur d'installer une résistance de pullup (10k) entre la
	// pin d'entrée du module et la borne vcc
	void gpmIOpinMode(byte p, byte mode);
	// nombre de satellites scannés
	int nbSateliteFound();
	// Y a-t-il assez de satellites (>2)
	boolean sateliteFound();
	// lecture en bloc des entrées digitales
	byte gpmIOdigitalReadBlock();
	// lecture d'une entrée digitale (numero n 1..4)
	boolean gpmIOdigitalRead(byte n);
	// lecture d'une entrée analogique (numéro n 1..4)
	byte gpmIOanalogRead(byte n) ;
	// écriture d'une sortie digitale (numero n 1..4 , true | false
	void gpmIOdigitalWrite(byte n, boolean v);
	// renvoi l'heure en nb de secondes depuis minuit
	uint32_t getTime();
	// renvoi le jour du mois 1..31
	uint8_t getDay();
	// renvoi le mois 1..12
	uint8_t getMonth();
	// renvoi l'année ex : 2025
	uint16_t getYear();
	// renvoi l'altitude en m
	long getAltitude();
	// renvoi la latitude en unité de 1E-6 degrés
	long getLatitude();
	// renvoi la longitude en unité de 1E-6 degrés
	long getLongitude();
	// renvoi la vitesse en unité de 0.1 km/s
	int getSpeed();
	// renvoi la direction de deplacement en unité de 1/10 degré /nord geographique
	int getHeadingGeo();
	// renvoi la direction de deplacement en unité de 1/10 degré /nord magnetique
	int getHeadingMag();
	// renvoi la valeur de l'accelerometre en X (>0 ou <0)
	int getAccelX();
	// renvoi la valeur de l'accelerometre en Y (>0 ou <0)
	int getAccelY();
	// renvoi la valeur de l'accelerometre en Z (>0 ou <0)
	int getAccelZ();
	// modifie la référence de l'accélération sur X
	void setRefGx(int v);
	// modifie la référence de l'accélération sur Y
	void setRefGy(int v);
	// modifie la référence de l'accélération sur Z
	void setRefGz(int v);
	// renvoi le nombre de G sur l'axe X (relativement à 1Gx)
	float getGx();
	// renvoi le nombre de G sur l'axe Y (relativement à 1Gy)
	float getGy();
	// renvoi le nombre de G sur l'axe Z (relativement à 1Gz)
	float getGz();
	// renvoi la valeur de l'inclinaison frontale "tangage" (pitch)(>0 ou <0)en degré
	int getPitch();
	// renvoi la valeur de l'inclinaison latérale  "roulis" (roll)(>0 ou <0) en degré
	int getRoll();
	
	private :
	// acquiére n bytes de l'I2c à partir de l'adresse addr
	uint32_t getMultiple(byte addr, byte n);
	// acquiére 3 bytes de l'I2c à partir de l'adresse addr
	int getTriple(byte addr);
	// acquiére 2 bytes de l'I2c à partir de l'adresse addr
	int getDouble(byte addr);
	// acquiére 1 byte de l'I2c à partir de l'adresse addr
	byte getSingle(int addr);
	// acquiére 1 byte signé de l'I2c à partir de l'adresse addr
	int getSignedByte(int addr);
	// acquiére un mot (2 byte) signé de l'I2c à partir de l'adresse addr
	int getSignedWord(int addr);
};

#endif
