/* 
Programme de demonstration du shield GPM
Attention ce shield fonctionne sur un uno ou nano
sur le shield les broches 
  sda est cablée sur A4
  slc est cablée sur A5
*/

// uncomment your version of shield !
//#define _GPAM // uncomment this line for GPMA version correpond at IES-Shield-GPAM
//#define _GPM  // uncomment this line for GPM version correspond at DS-GPM Shield
//#define _GPMP // uncomment this line for GPMP version correspond at sHLD-GPM+

// see the documentation of various shield included in the librarie in doc folder

// if you do not specified a shield, all extra functions except gps standard functions 
// will be annihilate ie : they do not have any action or return 0
 
// inclusion des bibliothèques
#include <gpm.h>

Gpm Gps1;  // une instance de Gpm avec l'adresse standard 0x68
void setup() {
  Gps1.init();         // initialisation de la communication
  Serial.begin(9600);  // initialisation de la sortie série
  while (!Serial) {};

  // Positionnement des E/S externes
  // E/S digitales
  Gps1.gpmIOpinMode(1, INPUT);
  Gps1.gpmIOpinMode(2, OUTPUT);

  // Entrées analogiques
  Gps1.gpmIOpinMode(3, ANALOG);  
  Gps1.gpmIOpinMode(4, ANALOG);
}

// programme principal
void loop() {
  if (Gps1.sateliteFound()) {
    Serial.print("Nb Satelite : ");
    Serial.println(Gps1.nbSateliteFound());

    // affichage de l'heure GMT
    Serial.print("Time: ");
    long t = Gps1.getTime();
    int h = t / 3600;
    if (h < 10) Serial.print('0');
    Serial.print(h, DEC);  //, DEC);  //heure à partir des secondes
    Serial.print(':');
    int m = t / 60 - h * 60;
    if (m < 10) Serial.print('0');
    Serial.print(m, DEC);  // minutes à partir des secondes
    Serial.print(':');
    int s = t - h * 3600 - m * 60;
    if (s < 10) Serial.print('0');
    Serial.println(s, DEC);
    Serial.print("Latitude: ");
    Serial.print(float(Gps1.getLatitude()) / 1E6, 4);
    Serial.println("°");
    Serial.print("Longitude: ");
    Serial.print(float(Gps1.getLongitude()) / 1E6, 4);
    Serial.println("°");
    Serial.print("Altitude: ");
    Serial.print(Gps1.getAltitude());
    Serial.println('m');
    Serial.print("Direction: ");
    Serial.print(float(Gps1.getHeadingGeo()) / 10, 1);
    Serial.println("°");
    Serial.print("Vitesse: ");
    Serial.print(float(Gps1.getSpeed()) / 10, 1);
    Serial.println("km/h");
  } else Serial.println("pas de connection !");
  // l'acceleromètre interne
  Serial.print("accel X : ");Serial.print(Gps1.getAccelX()) ; Serial.print(" Gx : "); Serial.print(Gps1.getGx(),4);Serial.println("G");
   Serial.print("accel Y : ");Serial.print(Gps1.getAccelY()) ; Serial.print(" Gy : "); Serial.print(Gps1.getGy(),4);Serial.println("G");
    Serial.print("accel Z : ");Serial.print(Gps1.getAccelZ()) ; Serial.print(" Gz : "); Serial.print(Gps1.getGz(),4);Serial.println("G");
  // travail sur les I/O externes
  Gps1.gpmIOdigitalWrite(2, !Gps1.gpmIOdigitalRead(1));  // on recopie la non valeur de 1 sur 2
  Serial.println("entrées analogiques");
  Serial.print("N° 3 : ");
  Serial.println(Gps1.gpmIOanalogRead(3));
  Serial.print("N° 4 : ");
  Serial.println(Gps1.gpmIOanalogRead(4));
  Serial.println();
  delay(1000);
}
